def slice_matrix(m: list[list[int]], start: slice, end: slice) -> list[list[int]]:
    return [row[end] for row in m[start]]


def split_list(data_list: list) -> tuple[list, list]:
    half = len(data_list) // 2
    return (data_list[:half], data_list[half:])


def split_sort(data_list: list) -> list:
    data_list.sort()
    a, b = split_list(data_list)
    b.sort(reverse=True)
    a.extend(b)
    return a


def main(data: list[int], nums: list[int]) -> None:
    x, y, c, d = data

    if c < d:
        c, d = d, c

    matrix = []

    for i in range(x):
        z = []
        for j in range(y):
            z.append(nums[y * i + j])

        matrix.append(split_sort(z))

    matrix = split_sort(matrix)

    rez = []

    for i in range(x):
        for j in range(y):
            if i + c > x or j + d > y:
                break
            rez.append(
                sum(
                    [
                        sum(row)
                        for row in slice_matrix(
                            matrix, slice(i, i + c), slice(j, j + d)
                        )
                    ]
                )
            )

    print(sum(rez))


main([int(i) for i in input().split(" ")], [int(i) for i in input().split(" ")])